import { Component, OnInit } from '@angular/core';
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { Product } from '../../core/maincontent/product'
import { ActiveState } from '../../core/activestate/activestate.service'

@Component({
  selector: 'app-non-mccf-home',
  templateUrl: './non-mccf-home.component.html',
  styleUrls: ['./non-mccf-home.component.css']
})
export class NonMccfHomeComponent implements OnInit {
  maincontentService: MainContentService
  product: Product

  constructor(public activeState: ActiveState,
          private mcService: MainContentService) {
    this.maincontentService = mcService
  }

  ngOnInit() {
    this.maincontentService.getProduct('non-mccf').subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(prod: Product) {
    this.product = prod
  }

}
